#ifndef _METER_MCU_H_
#define _METER_MCU_H_

#include "csg_structure.h"
#include <msp430xG46x.h>
#include <string.h>
#include "lcd.h"
#include "csg2dlt645.h"

extern unsigned int gFlag;
extern unsigned char gStatus;
extern struct csg_phase_parms_s meter1;

#define BAUTRATE_9600
#define USART0_BAUD_RATE 9600

#define CHECKSUMUSED
//#undef CHECKSUMUSED

#define FL_AFE_INTERRUPT_IN 0x0001    //AFE event triggerred
#define FL_AFE_READ         0x0010    //one AFE packet read in afe_read_message[]
#define FL_HST_READ_AFE_CAL 0x0100    //host require read AFE calibration data
#define FL_HST_READ_AFE_CONF 0x0200    //host require read AFE configuration data
#define FL_HST_SET_AFE_CAL  0x0400    //host require write AFE calibration data
#define FL_HST_SET_AFE_REG  0x0800    //host require write AFE configuration data
#define FL_AFE_READING_OUT_EN 0x1000    //AFE event triggerred
#define FL_AFE_READING_OUT_CH 0x2000    //AFE event triggerred
#define FL_SELFTEST_KICKER  0x8000    //for self test

#define ST_AFE_READING 0x01       //one byte is reading from AFE
#define ST_AFE_WRITING 0x02       //one packet is writing to AFE
#define ST_AFE_READING_TOUT 0x04  //CSG reading timeout
#define ST_AFE_INTERVAL_REACHED 0x08  //1ms interval reached after last sent/received bytes

#define TIMEROUT_AFE_READ 32768    //1s
//#define INTERVAL_BETWEEN_BYTES 327       //10ms
#define INTERVAL_BETWEEN_BYTES 65       //2ms

#define phase                           (&meter1.metrology)
#define phase_nv                        (&meter1.nv_parms)
#define phase_nv_new                    (&meter1.nv_parms_new)
#define neutral_nv                      (&meter1.nv_parms.current[1])
#define phase_conf                      (&meter1.config)
#define phase_conf_new                  (&meter1.config_new)

#define       OS_START_WDT()          WDTCTL = WDT_ARST_1000       //ʹܿŹ
#define       OS_STOP_WDT()           WDTCTL = WDTPW+WDTHOLD       //ֹͣŹ
#define       REG_Configure(a,b,c)    memcpy(a,b,c)
#define       BT_Init()               BTCTL = BT_ADLY_2000 + 0x08;         // ʱ1000ms
#define       LCD_Write(a,b)          LCDMEM[a]=b
#define       ENIT_GIE()              _EINT()
#define       Reg_Write(Reg_Add,Data) *Reg_Add=Data
#define       Read_Result(x)          (x)?SET:RESET

#define       BT_FLAG                  Run_Flag.Word_bit.bit0        //ʱ־
#define       HALF_SEC_FLAG            Run_Flag.Word_bit.bit1
#define       SEC_FLAG                 Run_Flag.Word_bit.bit2
#define       DISP_FLAG                Run_Flag.Word_bit.bit3        //ʾʹܱ־
#define       E2ROM_FLAG               Run_Flag.Word_bit.bit4        //ݴ洢־
#define       READ_CSG550_FLAG         Run_Flag.Word_bit.bit5        //CSG550־
#define       COM_FLAG                 Run_Flag.Word_bit.bit6        //ͨű־
#define       COM_DISP_FALG            Run_Flag.Word_bit.bit7        //ͨʾ־
#define       CFG_FLAG                 Run_Flag.Word_bit.bit8        //־ 
#define       EC_FLAG                  Run_Flag.Word_bit.bit9        //Ϣ־
#define       RUN_FLAG                 Run_Flag.Word_V

#define       NEGA_FLAG                Meter_State.Byte_bit.bit0     //Ա־
#define       PROG_STATE               Meter_State.Byte_bit.bit1     //̼״̬־    

/***************** P5˿ **************************************/
#define       SEG0            BIT1
#define       SEG1            BIT0
#define	      COM1	      BIT2
#define	      COM2	      BIT3
#define	      COM3	      BIT4
#define       R33             BIT7
#define       R23             BIT6
#define       R13             BIT5
/***************** P6˿ **************************************/
#define	      SDA						  BIT0
#define	      SCL						  BIT1
#define	      WP						  BIT2
#define	      RELAY1					BIT3
#define	      RELAY2					BIT4
#define	      YELLOW_LED			BIT5
#define	      RED_LED				  BIT6
#define	      LIGHT					  BIT7

/*****************    ⲿ  ********************/
extern void _BIN_BCD(unsigned char *Ptr1,unsigned char *Ptr2);

extern volatile Word_Bit_type         Run_Flag;               //ִпλ
extern volatile Char_Bit_type         Meter_State;            //ܱ״̬λ
extern int8_t lcd_page;       //lcd dispaly page #
#endif